/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.CEADescriptor;
import com.quantumdata.edideditor.DescriptorType;
import com.quantumdata.edideditor.MyByte;

public class CEAVCD
extends CEADescriptor {
    private static final int byte_0 = 0;
    private int byte_1 = 0;
    private static final int iDescriptorSize = 2;
    private static final int iQuantizationRangeOffset = 6;
    private static final int iPTOverscanOffset_1 = 5;
    private static final int iPTOverscanOffset_0 = 4;
    private static final int iITOverscanOffset_1 = 3;
    private static final int iITOverscanOffset_0 = 2;
    private static final int iCEOverscanOffset_1 = 1;
    private static final int iCEOverscanOffset_0 = 0;

    public CEAVCD() {
        super(DescriptorType.VIDEO_CAP_DES, 2);
    }

    public void setQuantizationRange(int n) {
        this.byte_1 = MyByte.turnOffBit(this.byte_1, 6);
        this.byte_1 |= n << 6;
    }

    public int getQuantizationRange() {
        int n = MyByte.maskOffBit(this.byte_1, 6);
        return n >>= 6;
    }

    public void setPTOverscan(int n) {
        this.byte_1 = MyByte.turnOffBit(this.byte_1, 5);
        this.byte_1 = MyByte.turnOffBit(this.byte_1, 4);
        this.byte_1 |= n << 4;
    }

    public int getPTOverscan() {
        int n = MyByte.maskOffBitRange(this.byte_1, 5, 4);
        return n >>= 4;
    }

    public void setITOverscan(int n) {
        if (n >= 4) {
            System.out.println("ERROR");
            System.exit(1);
        }
        this.byte_1 = MyByte.turnOffBit(this.byte_1, 3);
        this.byte_1 = MyByte.turnOffBit(this.byte_1, 2);
        this.byte_1 |= n << 2;
    }

    public int getITOverscan() {
        int n = MyByte.maskOffBitRange(this.byte_1, 3, 2);
        return n >>= 2;
    }

    public void setCEOverscan(int n) {
        if (n >= 4) {
            System.out.println("ERROR");
            System.exit(1);
        }
        this.byte_1 = MyByte.turnOffBit(this.byte_1, 1);
        this.byte_1 = MyByte.turnOffBit(this.byte_1, 0);
        this.byte_1 |= n << 0;
    }

    public int getCEOverscan() {
        int n = MyByte.maskOffBitRange(this.byte_1, 1, 0);
        return n >>= 0;
    }

    public void uploadDescriptorData(String string) {
        if (string.length() > 4) {
            return;
        }
        int n = Integer.parseInt(string.substring(0, 2), 16);
        if (n != 0) {
            System.out.println("ERROR");
            System.exit(1);
        }
        this.byte_1 = Integer.parseInt(string.substring(2, 4), 16);
    }

    public String extractDescriptorData() {
        String string = new String();
        string = string.concat(String.format("%02X", 0));
        string = string.concat(String.format("%02X", this.byte_1));
        return string;
    }
}

